/*
 * Decompiled with CFR 0.152.
 */
import com.google.gson.Gson;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TCPChat
implements Runnable {
    public static final int NULL = 0;
    public static final int DISCONNECTED = 1;
    public static final int DISCONNECTING = 2;
    public static final int BEGIN_CONNECT = 3;
    public static final int CONNECTED = 4;
    public static final String[] statusMessages = new String[]{" Error! Could not connect!", " Disconnected", " Disconnecting...", " Connecting...", " Connected"};
    public static final TCPChat tcpObj = new TCPChat();
    public static final String END_CHAT_SESSION = new Character('\u0000').toString();
    public static String hostIP = "localhost";
    public static int port = 9876;
    public static int connectionStatus = 1;
    public static boolean isHost = true;
    public static String statusString = statusMessages[connectionStatus];
    public static StringBuffer toAppend = new StringBuffer("");
    public static StringBuffer toSend = new StringBuffer("");
    public static JFrame mainFrame = null;
    public static JTextArea chatText = null;
    public static JTextField chatLine = null;
    public static JPanel statusBar = null;
    public static JLabel statusField = null;
    public static JTextField statusColor = null;
    public static JTextField ipField = null;
    public static JTextField portField = null;
    public static JRadioButton hostOption = null;
    public static JRadioButton guestOption = null;
    public static JButton connectButton = null;
    public static JButton disconnectButton = null;
    public static ServerSocket hostServer = null;
    public static Socket socket = null;
    public static BufferedReader in = null;
    public static PrintWriter out = null;
    private static JTextField txtScaleWeight;
    private static JButton btnWeight;
    private static JCheckBox ckbScaleRead;
    private static Thread tmThread;
    private static JButton btnUnit;

    static {
        ckbScaleRead = null;
        tmThread = null;
    }

    private static JPanel initOptionsPane() {
        JPanel pane = null;
        ActionAdapter buttonListener = null;
        JPanel optionsPane = new JPanel(new GridLayout(6, 1));
        pane = new JPanel(new FlowLayout(2));
        pane.add(new JLabel("Host IP:"));
        ipField = new JTextField(10);
        ipField.setText(hostIP);
        ipField.setEnabled(false);
        ipField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ipField.selectAll();
                if (connectionStatus != 1) {
                    TCPChat.changeStatusNTS(0, true);
                } else {
                    hostIP = ipField.getText();
                }
            }
        });
        JPanel panel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel.getLayout();
        flowLayout.setAlignment(2);
        optionsPane.add(panel);
        JLabel lblNewLabel = new JLabel("Scale:");
        panel.add(lblNewLabel);
        txtScaleWeight = new JTextField();
        txtScaleWeight.setHorizontalAlignment(4);
        txtScaleWeight.setEditable(false);
        txtScaleWeight.setText("0.00");
        txtScaleWeight.setFont(new Font("Tahoma", 1, 16));
        panel.add(txtScaleWeight);
        txtScaleWeight.setColumns(9);
        pane.add(ipField);
        optionsPane.add(pane);
        pane = new JPanel(new FlowLayout(2));
        pane.add(new JLabel("Port:"));
        portField = new JTextField(10);
        portField.setEditable(true);
        portField.setText(new Integer(port).toString());
        portField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (connectionStatus != 1) {
                    TCPChat.changeStatusNTS(0, true);
                } else {
                    try {
                        int temp;
                        port = temp = Integer.parseInt(portField.getText());
                    }
                    catch (NumberFormatException nfe) {
                        portField.setText(new Integer(port).toString());
                        mainFrame.repaint();
                    }
                }
            }
        });
        pane.add(portField);
        optionsPane.add(pane);
        buttonListener = new ActionAdapter(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (connectionStatus != 1) {
                    TCPChat.changeStatusNTS(0, true);
                } else {
                    isHost = e.getActionCommand().equals("host");
                    if (isHost) {
                        ipField.setEnabled(false);
                        ipField.setText("localhost");
                        hostIP = "localhost";
                    } else {
                        ipField.setEnabled(true);
                    }
                }
            }
        };
        ButtonGroup bg = new ButtonGroup();
        hostOption = new JRadioButton("Host", true);
        hostOption.setMnemonic(72);
        hostOption.setActionCommand("host");
        hostOption.addActionListener(buttonListener);
        guestOption = new JRadioButton("Guest", false);
        guestOption.setMnemonic(71);
        guestOption.setActionCommand("guest");
        guestOption.addActionListener(buttonListener);
        bg.add(hostOption);
        bg.add(guestOption);
        pane = new JPanel(new GridLayout(1, 2));
        pane.add(hostOption);
        pane.add(guestOption);
        optionsPane.add(pane);
        buttonListener = new ActionAdapter(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("connect")) {
                    TCPChat.changeStatusNTS(3, true);
                } else {
                    TCPChat.changeStatusNTS(2, true);
                }
            }
        };
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        connectButton = new JButton("Connect");
        connectButton.setMnemonic(67);
        connectButton.setActionCommand("connect");
        connectButton.addActionListener(buttonListener);
        connectButton.setEnabled(true);
        disconnectButton = new JButton("Disconnect");
        disconnectButton.setMnemonic(68);
        disconnectButton.setActionCommand("disconnect");
        disconnectButton.addActionListener(buttonListener);
        disconnectButton.setEnabled(false);
        buttonPane.add(connectButton);
        buttonPane.add(disconnectButton);
        optionsPane.add(buttonPane);
        JPanel panel_Scale = new JPanel();
        optionsPane.add(panel_Scale);
        panel_Scale.setLayout(null);
        ckbScaleRead = new JCheckBox("continue read");
        ckbScaleRead.setBounds(0, 40, 119, 23);
        panel_Scale.add(ckbScaleRead);
        btnUnit = new JButton("UNIT");
        btnUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("UNIT")) {
                    TCPChat.sendString("~*U*~");
                }
            }
        });
        btnUnit.setBounds(119, 5, 65, 50);
        panel_Scale.add(btnUnit);
        btnWeight = new JButton("Weight");
        btnWeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("Weight")) {
                    TCPChat.sendString("~*W*~");
                }
            }
        });
        btnWeight.setBounds(0, 5, 98, 35);
        panel_Scale.add(btnWeight);
        ckbScaleRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                if (cb.isSelected()) {
                    if (tmThread == null) {
                        tmThread = new MThread(new Runnable(){
                            int cid = 0;
                            String sid = "";

                            @Override
                            public void run() {
                                while (!tmThread.isInterrupted()) {
                                    if (connectionStatus == 4) {
                                        this.sid = this.cid == 125 ? "}m" : (this.cid == 126 ? "}n" : Character.toString((char)this.cid));
                                        TCPChat.sendString("~*W" + this.sid + "~");
                                        String ch = "~*W" + this.sid + "~";
                                        System.out.print(String.valueOf(ch) + "\n");
                                        ++this.cid;
                                        this.cid &= 0x7F;
                                    }
                                    try {
                                        Thread.sleep(333L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                tmThread = null;
                            }
                        });
                        tmThread.start();
                    }
                } else if (tmThread != null) {
                    tmThread.interrupt();
                }
            }
        });
        return optionsPane;
    }

    private static void initGUI() {
        statusField = new JLabel();
        statusField.setText(statusMessages[1]);
        statusColor = new JTextField(1);
        statusColor.setBackground(Color.red);
        statusColor.setEditable(false);
        statusBar = new JPanel(new BorderLayout());
        statusBar.add((Component)statusColor, "West");
        statusBar.add((Component)statusField, "Center");
        JPanel optionsPane = TCPChat.initOptionsPane();
        JPanel chatPane = new JPanel(new BorderLayout());
        chatText = new JTextArea(10, 10);
        chatText.setLineWrap(true);
        chatText.setEditable(false);
        chatText.setForeground(Color.blue);
        JScrollPane chatTextPane = new JScrollPane(chatText, 22, 31);
        chatLine = new JTextField();
        chatLine.setEnabled(false);
        chatLine.addActionListener(new ActionAdapter(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = chatLine.getText();
                if (!s.equals("")) {
                    TCPChat.appendToChatBox("OUTGOING: " + s + "\n");
                    chatLine.selectAll();
                    TCPChat.sendString(s);
                }
            }
        });
        chatPane.add((Component)chatLine, "South");
        chatPane.add((Component)chatTextPane, "Center");
        chatPane.setPreferredSize(new Dimension(800, 400));
        JPanel mainPane = new JPanel(new BorderLayout());
        mainPane.add((Component)statusBar, "South");
        mainPane.add((Component)optionsPane, "West");
        mainPane.add((Component)chatPane, "Center");
        mainFrame = new JFrame("Simple TCP Chat");
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setContentPane(mainPane);
        mainFrame.setSize(mainFrame.getPreferredSize());
        mainFrame.setLocation(100, 200);
        mainFrame.pack();
        mainFrame.setVisible(true);
    }

    private static void changeStatusTS(int newConnectStatus, boolean noError) {
        if (newConnectStatus != 0) {
            connectionStatus = newConnectStatus;
        }
        statusString = noError ? statusMessages[connectionStatus] : statusMessages[0];
        SwingUtilities.invokeLater(tcpObj);
    }

    private static void changeStatusNTS(int newConnectStatus, boolean noError) {
        if (newConnectStatus != 0) {
            connectionStatus = newConnectStatus;
        }
        statusString = noError ? statusMessages[connectionStatus] : statusMessages[0];
        tcpObj.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendToChatBox(String s) {
        StringBuffer stringBuffer = toAppend;
        synchronized (stringBuffer) {
            toAppend.append(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendString(String s) {
        StringBuffer stringBuffer = toSend;
        synchronized (stringBuffer) {
            toSend.append(String.valueOf(s) + "\n");
        }
    }

    private static void cleanUp() {
        try {
            if (hostServer != null) {
                hostServer.close();
                hostServer = null;
            }
        }
        catch (IOException e) {
            hostServer = null;
        }
        try {
            if (socket != null) {
                socket.close();
                socket = null;
            }
        }
        catch (IOException e) {
            socket = null;
        }
        try {
            if (in != null) {
                in.close();
                in = null;
            }
        }
        catch (IOException e) {
            in = null;
        }
        if (out != null) {
            out.close();
            out = null;
        }
    }

    @Override
    public void run() {
        switch (connectionStatus) {
            case 1: {
                connectButton.setEnabled(true);
                disconnectButton.setEnabled(false);
                ipField.setEnabled(true);
                portField.setEnabled(true);
                hostOption.setEnabled(true);
                guestOption.setEnabled(true);
                chatLine.setText("");
                chatLine.setEnabled(false);
                statusColor.setBackground(Color.red);
                break;
            }
            case 2: {
                connectButton.setEnabled(false);
                disconnectButton.setEnabled(false);
                ipField.setEnabled(false);
                portField.setEnabled(false);
                hostOption.setEnabled(false);
                guestOption.setEnabled(false);
                chatLine.setEnabled(false);
                statusColor.setBackground(Color.orange);
                btnUnit.setEnabled(false);
                btnWeight.setEnabled(false);
                break;
            }
            case 4: {
                connectButton.setEnabled(false);
                disconnectButton.setEnabled(true);
                ipField.setEnabled(false);
                portField.setEnabled(false);
                hostOption.setEnabled(false);
                guestOption.setEnabled(false);
                chatLine.setEnabled(true);
                statusColor.setBackground(Color.green);
                btnUnit.setEnabled(true);
                btnWeight.setEnabled(true);
                break;
            }
            case 3: {
                connectButton.setEnabled(false);
                disconnectButton.setEnabled(false);
                ipField.setEnabled(false);
                portField.setEnabled(false);
                hostOption.setEnabled(false);
                guestOption.setEnabled(false);
                chatLine.setEnabled(false);
                chatLine.grabFocus();
                statusColor.setBackground(Color.orange);
            }
        }
        ipField.setText(hostIP);
        portField.setText(new Integer(port).toString());
        hostOption.setSelected(isHost);
        guestOption.setSelected(!isHost);
        statusField.setText(statusString);
        chatText.append(toAppend.toString());
        toAppend.setLength(0);
        mainFrame.repaint();
    }

    public static void main(String[] args) {
        TCPChat.initGUI();
        TCPChat.initScale();
        block11: while (true) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (connectionStatus) {
                case 3: {
                    try {
                        if (isHost) {
                            hostServer = new ServerSocket(port);
                            socket = hostServer.accept();
                        } else {
                            socket = new Socket(hostIP, port);
                        }
                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        out = new PrintWriter(socket.getOutputStream(), true);
                        TCPChat.changeStatusTS(4, true);
                    }
                    catch (IOException e) {
                        TCPChat.cleanUp();
                        TCPChat.changeStatusTS(1, false);
                    }
                    continue block11;
                }
                case 4: {
                    try {
                        String s;
                        if (toSend.length() != 0) {
                            out.print(toSend);
                            out.flush();
                            toSend.setLength(0);
                            TCPChat.changeStatusTS(0, true);
                        }
                        if (!in.ready() || (s = in.readLine()) == null || s.length() == 0) continue block11;
                        if (s.equals(END_CHAT_SESSION)) {
                            TCPChat.changeStatusTS(2, true);
                            continue block11;
                        }
                        TCPChat.appendToChatBox("INCOMING: " + s + "\n");
                        TCPChat.changeStatusTS(0, true);
                        if (!s.startsWith("{") || !s.endsWith("}")) continue block11;
                        Gson json = new Gson();
                        final AXScaleWeight objW = json.fromJson((String)s.subSequence(0, s.length()), AXScaleWeight.class);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                txtScaleWeight.setText(objW.getsWeight().toString());
                            }
                        });
                    }
                    catch (IOException e) {
                        TCPChat.cleanUp();
                        TCPChat.changeStatusTS(1, false);
                    }
                    continue block11;
                }
                case 2: {
                    out.print(END_CHAT_SESSION);
                    out.flush();
                    TCPChat.cleanUp();
                    TCPChat.changeStatusTS(1, true);
                    continue block11;
                }
            }
        }
    }

    private static void initScale() {
        guestOption.doClick();
        hostIP = "192.168.1.191";
        ipField.setText(hostIP);
        btnUnit.setEnabled(false);
        btnWeight.setEnabled(false);
        ckbScaleRead.setSelected(false);
    }
}

